<?php
/**
 * Plugin uninstaller logic.
 *
 * @package optimization-detective
 * @since 0.1.0
 */

// If uninstall.php is not called by WordPress, bail.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit; // @codeCoverageIgnore
}

require_once __DIR__ . '/storage/class-od-url-metrics-post-type.php';

$od_delete_site_data = static function (): void {
	// Delete all URL Metrics posts for the current site.
	OD_URL_Metrics_Post_Type::delete_all_posts();
	wp_unschedule_hook( OD_URL_Metrics_Post_Type::GC_CRON_EVENT_NAME );

	// Clear out options and transients.
	delete_option( 'od_rest_api_unavailable' );
	delete_transient( 'od_rest_api_health_check_response' );
};

$od_delete_site_data();

/*
 * For a multisite install, delete the URL Metrics for all other sites (however, this is limited to 100 sites to avoid memory limit
 * and timeout problems in large scale networks).
 */
if ( is_multisite() ) {
	$od_site_ids = get_sites(
		array(
			'fields'                 => 'ids',
			'number'                 => 100,
			'update_site_cache'      => false,
			'update_site_meta_cache' => false,
		)
	);

	// Skip iterating over self.
	$od_site_ids = array_diff(
		$od_site_ids,
		array( get_current_blog_id() )
	);

	// Delete all other blogs' URL Metrics posts.
	foreach ( $od_site_ids as $od_site_id ) {
		switch_to_blog( $od_site_id );
		$od_delete_site_data();
		restore_current_blog();
	}
}
